/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.distribution;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.distribution.DistributionApi;
import org.apache.ignite3.internal.rest.api.distribution.ResetDistributionRequest;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/distribution")
public class DistributionController
implements DistributionApi,
ResourceHolder,
SecurityContextAware {
    private DisasterRecoveryManager disasterRecoveryManager;
    private final SecurityService securityService;

    public DistributionController(DisasterRecoveryManager disasterRecoveryManager, SecurityService securityService) {
        this.disasterRecoveryManager = disasterRecoveryManager;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<Void> reset(@Body ResetDistributionRequest request) {
        return this.secured(() -> this.disasterRecoveryManager.resetDistribution(request.zoneNames()));
    }

    @Override
    public void cleanResources() {
        this.disasterRecoveryManager = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

