/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.authentication;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.security.authentication.AuthenticationManager;
import org.apache.ignite3.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite3.security.exception.InvalidCredentialsException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class IgniteAuthenticationProvider
implements AuthenticationProvider,
ResourceHolder {
    private AuthenticationManager authenticationManager;

    IgniteAuthenticationProvider(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    boolean authenticationEnabled() {
        return this.authenticationManager.authenticationEnabled();
    }

    public Publisher<AuthenticationResponse> authenticate(HttpRequest<?> httpRequest, AuthenticationRequest<?, ?> authenticationRequest) {
        return Flux.create(emitter -> {
            try {
                this.authenticationManager.authenticateAsync(IgniteAuthenticationProvider.toIgniteAuthenticationRequest(authenticationRequest)).handle((userDetails, throwable) -> {
                    if (throwable != null) {
                        emitter.error((Throwable)AuthenticationResponse.exception((String)throwable.getMessage()));
                    } else {
                        emitter.next((Object)AuthenticationResponse.success((String)userDetails.username(), userDetails.roles()));
                        emitter.complete();
                    }
                    return null;
                });
            }
            catch (InvalidCredentialsException ex) {
                emitter.error((Throwable)AuthenticationResponse.exception((String)ex.getMessage()));
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
    }

    private static org.apache.ignite3.internal.security.authentication.AuthenticationRequest<?, ?> toIgniteAuthenticationRequest(AuthenticationRequest<?, ?> authenticationRequest) {
        if (authenticationRequest instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)authenticationRequest;
            return new UsernamePasswordRequest(usernamePasswordCredentials.getIdentity(), usernamePasswordCredentials.getPassword());
        }
        throw new IllegalArgumentException("Unsupported authentication request type: " + authenticationRequest.getClass());
    }

    @Override
    public void cleanResources() {
        this.authenticationManager = null;
    }
}

