/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.upgrade;

import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.upgrade.UpgradeStateResponse;

@Controller(value="/management/v1/upgrade")
@Secured(value={"isAuthenticated()"})
@Tag(name="upgrade")
public interface RollingUpgradeApi {
    @Operation(operationId="startUpgrade", summary="Start upgrade", description="Starts the rolling upgrade")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Upgrade successfully started.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="/start")
    @Consumes(value={"application/json"})
    public CompletableFuture<Boolean> startUpgrade(@Schema(name="version", description="The version to upgrade.", requiredMode=Schema.RequiredMode.REQUIRED) String var1);

    @Operation(operationId="commitUpgrade", summary="Commit upgrade", description="Commit the rolling upgrade")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Upgrade successfully commited.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="/commit")
    public CompletableFuture<Boolean> commitUpgrade();

    @Operation(operationId="cancelUpgrade", summary="Cancel upgrade", description="Cancel the rolling upgrade")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Upgrade successfully canceled.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="/cancel")
    public CompletableFuture<Boolean> cancelUpgrade();

    @Operation(operationId="upgradeState", summary="Upgrade state", description="Current state of the rolling upgrade")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpgradeStateResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/state")
    public CompletableFuture<UpgradeStateResponse> upgradeState();
}

