/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.license;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.rest.api.license.LicenseFeature;

@Schema(description="License features set representation.")
public class LicenseFeatureSet {
    @Schema(description="License features set.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final Set<LicenseFeature> features;

    @JsonCreator
    public LicenseFeatureSet(@JsonProperty(value="features") Set<LicenseFeature> features) {
        this.features = Objects.requireNonNullElse(features, Collections.emptySet());
    }

    @JsonGetter(value="features")
    public Set<LicenseFeature> features() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LicenseFeatureSet)) {
            return false;
        }
        LicenseFeatureSet that = (LicenseFeatureSet)o;
        return Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hashCode(this.features);
    }

    public String toString() {
        return "LicenseFeatureSet{features=" + this.features + "}";
    }
}

