/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.dcr.CreateReplicationRequest;
import org.apache.ignite3.internal.rest.api.dcr.FlushRequest;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationInfo;
import org.apache.ignite3.internal.rest.api.dcr.StartStopReplicationRequest;

@Controller(value="/management/v1/dcr")
@Secured(value={"isAuthenticated()"})
@Tag(name="dcr")
public interface DcrApi {
    @Operation(operationId="listReplications", summary="Retrieve a list of replications for connected clusters", description="Retrieves a list of replications for connected clusters.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful retrieval of all replication information.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ReplicationInfo.class)))}), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="replications")
    public CompletableFuture<Collection<ReplicationInfo>> listReplications();

    @Operation(operationId="createReplication", summary="Create a new replication for a cluster", description="Creates a new replication for a cluster.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication successfully created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReplicationInfo.class))}), @ApiResponse(responseCode="400", description="Replication already exists."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="replications")
    public CompletableFuture<ReplicationInfo> createReplication(@Body CreateReplicationRequest var1);

    @Operation(operationId="showReplication", summary="Get information about specific replication", description="Retrieves detailed information about a specific replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful retrieval of replication information.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReplicationInfo.class))}), @ApiResponse(responseCode="404", description="Replication not found."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="replications/{name}")
    public CompletableFuture<ReplicationInfo> showReplication(@Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED, description="The unique identifier of the replication.") String var1);

    @Operation(operationId="startReplication", summary="Start replication", description="Starts the specified replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication successfully started.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="404", description="Replication not found."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="replications/{name}/start")
    @Consumes(value={"application/json"})
    public CompletableFuture<Boolean> startReplication(@Schema(name="name", description="The unique identifier of the replication.", requiredMode=Schema.RequiredMode.REQUIRED) String var1, @Body StartStopReplicationRequest var2);

    @Operation(operationId="stopReplication", summary="Stop replication", description="Stops the specified replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication successfully stopped.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="404", description="Replication not found."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="replications/{name}/stop")
    public CompletableFuture<Boolean> stopReplication(@Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED, description="The id of the replication.") String var1, @Body StartStopReplicationRequest var2);

    @Operation(operationId="deleteReplication", summary="Delete replication", description="Deletes the specified replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication successfully deleted.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="404", description="Replication not found."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="replications/{name}/delete")
    public CompletableFuture<Boolean> deleteReplication(@Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED, description="The name of the replication.") String var1);

    @Operation(operationId="flushReplication", description=".")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication successfully flushed.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="404", description="Replication not found."), @ApiResponse(responseCode="500", description="Internal server error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="replications/{name}/flush")
    public CompletableFuture<Boolean> flush(@Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED, description="The id of the replication.") String var1, @Body FlushRequest var2);
}

