/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import org.apache.ignite3.internal.rest.api.dcr.AuthConfig;
import org.apache.ignite3.internal.rest.api.dcr.SslConfig;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="DTO for creating a cluster replication request.")
public class CreateReplicationRequest {
    @Schema(description="Replication name.")
    private final String name;
    @Schema(description="List of node addresses of the source cluster.")
    private final Set<String> sourceClusterAddresses;
    @Schema(description="Auth config of the connection to the source cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final AuthConfig authConfig;
    @Schema(description="SSL config of the connection to the source cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final SslConfig sslConfig;
    @Schema(description="List of replication nodes names on target cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final Set<String> replicationNodes;

    @JsonCreator
    public CreateReplicationRequest(@JsonProperty(value="name") String name, @JsonProperty(value="sourceClusterAddresses") Set<String> sourceClusterAddresses, @JsonProperty(value="sourceClusterAuthConfig") @Nullable AuthConfig authConfig, @JsonProperty(value="sourceClusterSslConfig") @Nullable SslConfig sslConfig, @JsonProperty(value="replicationNodes") Set<String> replicationNodes) {
        this.name = name;
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.replicationNodes = replicationNodes;
    }

    @JsonGetter
    public String name() {
        return this.name;
    }

    @JsonGetter
    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @JsonGetter
    @Nullable
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @JsonGetter
    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    @JsonGetter
    public Set<String> replicationNodes() {
        return this.replicationNodes;
    }

    public String toString() {
        return S.toString(this);
    }
}

