/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.configuration;

import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;

@Controller(value="/management/v1/configuration/cluster/")
@Tag(name="clusterConfiguration")
public interface ClusterConfigurationApi {
    @Operation(operationId="getClusterConfiguration", summary="Get cluster configuration", description="Gets the current configuration of the cluster. The configuration is returned in HOCON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Received cluster configuration.", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Configuration not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"text/plain", "application/problem+json"})
    @Get
    public HttpResponse<String> getConfiguration();

    @Operation(operationId="updateClusterConfiguration", summary="Update cluster configuration", description="Updates cluster configuration. New configuration should be provided in HOCON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Configuration updated."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Configuration not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="422", description="Configuration parse error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"text/plain"})
    @Produces(value={"application/problem+json"})
    @Patch
    public CompletableFuture<Void> updateConfiguration(@Body @RequestBody(description="The cluster configuration to update.") String var1);

    @Operation(operationId="getClusterConfigurationByPath", summary="Get configuration represented by path", description="Gets the configuration on the specific path. Configuration is in HOCON format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Configuration of the cluster on the specified path.", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Configuration not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"text/plain", "application/problem+json"})
    @Get(value="/{path}")
    public HttpResponse<String> getConfigurationByPath(@PathVariable(value="path") @Parameter(required=true, description="Configuration tree address. For example: `element.subelement`.") String var1);
}

