/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Cdc sink/source check result", name="CheckResult")
public class Violations {
    @Schema(description="Violation name")
    private final String name;
    @Schema(description="Error details")
    @Nullable
    private final String errorDetails;

    @JsonCreator
    public Violations(@JsonProperty(value="name") String name, @JsonProperty(value="errorDetails") @Nullable String errorDetails) {
        this.name = name;
        this.errorDetails = errorDetails;
    }

    @JsonGetter
    public String name() {
        return this.name;
    }

    @JsonGetter
    @Nullable
    public String errorDetails() {
        return this.errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Violations that = (Violations)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.errorDetails);
    }

    public String toString() {
        return S.toString(Violations.class, this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String errorDetails;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public Violations build() {
            return new Violations(this.name, this.errorDetails);
        }
    }
}

