/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.rest.api.cdc.SinkType;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Sink", name="Sink")
public class Sink {
    @Schema(description="Type")
    private final SinkType type;
    @Schema(description="Name")
    private final String name;
    @Schema(description="Parameters")
    private final Map<String, Object> parameters;
    @Schema(description="Create table if not exists", defaultValue="true")
    private final boolean createTableIfNotExists;

    @JsonCreator
    public Sink(@JsonProperty(value="type") SinkType type, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") @Nullable Map<String, Object> parameters, @JsonProperty(value="createTableIfNotExists") @Nullable Boolean createTableIfNotExists) {
        this.type = type;
        this.name = name;
        this.parameters = parameters == null ? null : new HashMap<String, Object>(parameters);
        this.createTableIfNotExists = createTableIfNotExists == null || createTableIfNotExists != false;
    }

    @JsonGetter(value="type")
    public SinkType type() {
        return this.type;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="parameters")
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @JsonGetter(value="createTableIfNotExists")
    public boolean createTableIfNotExists() {
        return this.createTableIfNotExists;
    }

    public String toString() {
        return S.toString(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sink sink = (Sink)o;
        return this.type == sink.type && Objects.equals(this.name, sink.name) && this.createTableIfNotExists == sink.createTableIfNotExists && Objects.equals(this.parameters, sink.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.parameters});
    }

    public static SinkBuilder builderFrom(Sink sink) {
        return new SinkBuilder().type(sink.type()).name(sink.name()).createTableIfNotExists(sink.createTableIfNotExists()).parameters(sink.parameters());
    }

    public static SinkBuilder builder() {
        return new SinkBuilder();
    }

    public static class SinkBuilder {
        private SinkType type;
        private String name;
        private Map<String, Object> parameters;
        private boolean createTableIfNotExists = true;

        public SinkBuilder type(SinkType type) {
            this.type = type;
            return this;
        }

        public SinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkBuilder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public SinkBuilder createTableIfNotExists(boolean createTableIfNotExists) {
            this.createTableIfNotExists = createTableIfNotExists;
            return this;
        }

        public Sink build() {
            return new Sink(this.type, this.name, this.parameters, this.createTableIfNotExists);
        }
    }
}

