/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.TimestampAwareReplicaResponse;
import org.apache.ignite3.internal.replicator.message.TimestampAwareReplicaResponseBuilder;
import org.apache.ignite3.internal.replicator.message.TimestampAwareReplicaResponseSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class TimestampAwareReplicaResponseImpl
implements TimestampAwareReplicaResponse,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private TimestampAwareReplicaResponseImpl(Object result, byte[] resultByteArray, HybridTimestamp timestamp) {
        this.result = result;
        this.resultByteArray = resultByteArray;
        this.timestamp = timestamp;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return TimestampAwareReplicaResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(TimestampAwareReplicaResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimestampAwareReplicaResponseImpl otherMessage = (TimestampAwareReplicaResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.timestamp);
        return result;
    }

    @Override
    public TimestampAwareReplicaResponseImpl clone() {
        try {
            return (TimestampAwareReplicaResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TimestampAwareReplicaResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
    }

    private static class Builder
    implements TimestampAwareReplicaResponseBuilder {
        private Object result;
        private byte[] resultByteArray;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public TimestampAwareReplicaResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public TimestampAwareReplicaResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public TimestampAwareReplicaResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TimestampAwareReplicaResponse build() {
            return new TimestampAwareReplicaResponseImpl(this.result, this.resultByteArray, this.timestamp);
        }

        @Override
        public TimestampAwareReplicaResponse buildDeserialized() {
            return new TimestampAwareReplicaResponseImpl(this.result, this.resultByteArray, this.timestamp);
        }
    }
}

