/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;

public class ReplicaMessageUtils {
    public static TablePartitionIdMessage toTablePartitionIdMessage(ReplicaMessagesFactory messagesFactory, TablePartitionId tablePartitionId) {
        return messagesFactory.tablePartitionIdMessage().tableId(tablePartitionId.tableId()).partitionId(tablePartitionId.partitionId()).build();
    }

    public static ZonePartitionIdMessage toZonePartitionIdMessage(ReplicaMessagesFactory messagesFactory, ZonePartitionId zonePartitionId) {
        return messagesFactory.zonePartitionIdMessage().zoneId(zonePartitionId.zoneId()).partitionId(zonePartitionId.partitionId()).build();
    }

    public static ZonePartitionIdMessage toReplicationGroupIdMessage(ReplicaMessagesFactory messagesFactory, ReplicationGroupId replicationGroupId) {
        assert (replicationGroupId instanceof ZonePartitionId) : "Unexpected type of replication group identifier [class=" + replicationGroupId.getClass().getSimpleName() + ", value=" + replicationGroupId + ", requiredType = ZonePartitionId].";
        return ReplicaMessageUtils.toZonePartitionIdMessage(messagesFactory, (ZonePartitionId)replicationGroupId);
    }
}

