/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.replicator.message.ErrorReplicaResponse;
import org.apache.ignite3.internal.replicator.message.ErrorReplicaResponseImpl;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesTypeInfos;

class ErrorReplicaResponseSerializer
implements MessageSerializer<ErrorReplicaResponse> {
    public static final ErrorReplicaResponseSerializer INSTANCE = new ErrorReplicaResponseSerializer();

    private ErrorReplicaResponseSerializer() {
    }

    @Override
    public boolean writeMessage(ErrorReplicaResponse msg, MessageWriter writer) throws MessageMappingException {
        ErrorReplicaResponseImpl message = (ErrorReplicaResponseImpl)msg;
        writer.setMessageTypeInfo(ReplicaMessagesTypeInfos.errorReplicaResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("resultByteArray", message.resultByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteArray("throwableByteArray", message.throwableByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

