/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ErrorReplicaResponse;
import org.apache.ignite3.internal.replicator.message.ErrorReplicaResponseBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesTypeInfos;

class ErrorReplicaResponseDeserializer
implements MessageDeserializer<ErrorReplicaResponse> {
    private final ErrorReplicaResponseBuilder msg;

    ErrorReplicaResponseDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.errorReplicaResponse();
    }

    @Override
    public Class<ErrorReplicaResponse> klass() {
        return ErrorReplicaResponse.class;
    }

    @Override
    public ErrorReplicaResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ReplicaMessagesTypeInfos.errorReplicaResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.resultByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.throwableByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ErrorReplicaResponse.class);
    }
}

