/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.command;

import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite3.internal.replicator.command.SafeTimeSyncCommandBuilder;
import org.apache.ignite3.internal.replicator.command.SafeTimeSyncCommandSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class SafeTimeSyncCommandImpl
implements SafeTimeSyncCommand,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private SafeTimeSyncCommandImpl(HybridTimestamp initiatorTime, HybridTimestamp safeTime) {
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return SafeTimeSyncCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(SafeTimeSyncCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SafeTimeSyncCommandImpl otherMessage = (SafeTimeSyncCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.safeTime);
        return result;
    }

    @Override
    public SafeTimeSyncCommandImpl clone() {
        try {
            return (SafeTimeSyncCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SafeTimeSyncCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SafeTimeSyncCommandBuilder {
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public SafeTimeSyncCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public SafeTimeSyncCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public SafeTimeSyncCommand build() {
            return new SafeTimeSyncCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime);
        }

        @Override
        public SafeTimeSyncCommand buildDeserialized() {
            return new SafeTimeSyncCommandImpl(this.initiatorTime, this.safeTime);
        }
    }
}

