/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite3.raft.jraft.option.LogStorageOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.jetbrains.annotations.Nullable;

class SegstoreLogStorage
implements LogStorage {
    private final long groupId;
    private final SegmentFileManager segmentFileManager;
    private volatile LogEntryEncoder logEntryEncoder;
    private volatile LogEntryDecoder logEntryDecoder;
    private volatile long firstLogIndexInclusive = -1L;
    private volatile long lastLogIndexInclusive = -1L;

    SegstoreLogStorage(long groupId, SegmentFileManager segmentFileManager) {
        if (groupId <= 0L) {
            throw new IllegalArgumentException("groupId must be greater than 0: " + groupId);
        }
        this.groupId = groupId;
        this.segmentFileManager = segmentFileManager;
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
        this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
        this.firstLogIndexInclusive = this.segmentFileManager.firstLogIndexInclusiveOnRecovery(this.groupId);
        this.lastLogIndexInclusive = Math.max(-1L, this.segmentFileManager.lastLogIndexExclusiveOnRecovery(this.groupId) - 1L);
        return true;
    }

    @Override
    public boolean appendEntry(LogEntry entry) {
        this.appendEntryImpl(entry);
        long firstLogIndexInclusive = this.firstLogIndexInclusive;
        if (firstLogIndexInclusive == -1L) {
            this.firstLogIndexInclusive = entry.getId().getIndex();
        }
        this.lastLogIndexInclusive = entry.getId().getIndex();
        return true;
    }

    private void appendEntryImpl(LogEntry entry) {
        try {
            this.segmentFileManager.appendEntry(this.groupId, entry, this.logEntryEncoder);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.appendEntryImpl(entry);
        }
        long firstLogIndexInclusive = this.firstLogIndexInclusive;
        if (firstLogIndexInclusive == -1L) {
            this.firstLogIndexInclusive = entries.get(0).getId().getIndex();
        }
        this.lastLogIndexInclusive = entries.get(entries.size() - 1).getId().getIndex();
        return entries.size();
    }

    @Override
    public long getFirstLogIndex() {
        long firstLogIndexInclusive = this.firstLogIndexInclusive;
        return firstLogIndexInclusive == -1L ? 1L : firstLogIndexInclusive;
    }

    @Override
    public long getLastLogIndex() {
        return Math.max(0L, this.lastLogIndexInclusive);
    }

    @Override
    @Nullable
    public LogEntry getEntry(long index) {
        try {
            return this.segmentFileManager.getEntry(this.groupId, index, this.logEntryDecoder);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        return entry == null ? 0L : entry.getId().getTerm();
    }

    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        try {
            this.segmentFileManager.truncatePrefix(this.groupId, firstIndexKept);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
        this.firstLogIndexInclusive = firstIndexKept;
        return true;
    }

    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        try {
            this.segmentFileManager.truncateSuffix(this.groupId, lastIndexKept);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
        this.lastLogIndexInclusive = lastIndexKept;
        return true;
    }

    @Override
    public boolean reset(long nextLogIndex) {
        try {
            this.segmentFileManager.reset(this.groupId, nextLogIndex);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
        this.firstLogIndexInclusive = nextLogIndex;
        this.lastLogIndexInclusive = nextLogIndex;
        return true;
    }

    @Override
    public void shutdown() {
    }
}

