/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot.incoming;

import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

class ReplicationLogStorageKey {
    @IgniteToStringInclude
    private final ReplicationGroupId replicationGroupId;
    private final boolean isVolatile;

    private ReplicationLogStorageKey(ReplicationGroupId replicationGroupId, boolean isVolatile) {
        this.replicationGroupId = replicationGroupId;
        this.isVolatile = isVolatile;
    }

    static ReplicationLogStorageKey create(PartitionSnapshotStorage snapshotStorage, PartitionMvStorageAccess mvStorage) {
        return new ReplicationLogStorageKey(snapshotStorage.partitionKey().toReplicationGroupId(), mvStorage.isVolatile());
    }

    ReplicationGroupId replicationGroupId() {
        return this.replicationGroupId;
    }

    boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationLogStorageKey that = (ReplicationLogStorageKey)o;
        return this.isVolatile == that.isVolatile && this.replicationGroupId.equals(that.replicationGroupId);
    }

    public int hashCode() {
        int result = this.replicationGroupId.hashCode();
        result = 31 * result + (this.isVolatile ? 1 : 0);
        return result;
    }

    public String toString() {
        return S.toString(ReplicationLogStorageKey.class, this);
    }
}

