/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot;

import java.util.Objects;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tostring.S;

public class ZonePartitionKey
implements PartitionKey {
    private final int zoneId;
    private final int partitionId;

    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    public ZonePartitionKey(int zoneId, int partitionId) {
        this.zoneId = zoneId;
        this.partitionId = partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZonePartitionKey that = (ZonePartitionKey)o;
        return this.partitionId == that.partitionId && this.zoneId == that.zoneId;
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.partitionId);
    }

    public String toString() {
        return S.toString(ZonePartitionKey.class, this);
    }

    @Override
    public ReplicationGroupId toReplicationGroupId() {
        return new ZonePartitionId(this.zoneId, this.partitionId);
    }
}

