/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequestSerializer;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

public class ReadOnlyDirectMultiRowReplicaRequestImpl
implements ReadOnlyDirectMultiRowReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 23;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteStringifier(name="primaryKeys.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> primaryKeys;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private ReadOnlyDirectMultiRowReplicaRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, List<ByteBuffer> primaryKeys, RequestType requestType, int schemaVersion, int tableId, HybridTimestamp timestamp) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.primaryKeys = primaryKeys;
        this.requestType = requestType;
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.timestamp = timestamp;
    }

    @Override
    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public List<ByteBuffer> primaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return ReadOnlyDirectMultiRowReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyDirectMultiRowReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 23;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyDirectMultiRowReplicaRequestImpl otherMessage = (ReadOnlyDirectMultiRowReplicaRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.primaryKeys, otherMessage.primaryKeys) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.schemaVersion == otherMessage.schemaVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.schemaVersion, this.tableId, this.enlistmentConsistencyToken, this.groupId, this.primaryKeys, this.requestType, this.timestamp});
        return result;
    }

    @Override
    public ReadOnlyDirectMultiRowReplicaRequestImpl clone() {
        try {
            return (ReadOnlyDirectMultiRowReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyDirectMultiRowReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyDirectMultiRowReplicaRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private List<ByteBuffer> primaryKeys;
        private RequestType requestType;
        private int schemaVersion;
        private int tableId;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder primaryKeys(List<ByteBuffer> primaryKeys) {
            Objects.requireNonNull(primaryKeys, "primaryKeys is not marked @Nullable");
            this.primaryKeys = primaryKeys;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public List<ByteBuffer> primaryKeys() {
            return this.primaryKeys;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequest build() {
            return new ReadOnlyDirectMultiRowReplicaRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.primaryKeys, "primaryKeys is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), this.schemaVersion, this.tableId, this.timestamp);
        }

        @Override
        public ReadOnlyDirectMultiRowReplicaRequest buildDeserialized() {
            return new ReadOnlyDirectMultiRowReplicaRequestImpl(this.enlistmentConsistencyToken, this.groupId, this.primaryKeys, this.requestType, this.schemaVersion, this.tableId, this.timestamp);
        }
    }
}

