/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.ContinuousQueryScanRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ContinuousQueryScanRequestBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ContinuousQueryScanRequestDeserializer
implements MessageDeserializer<ContinuousQueryScanRequest> {
    private final ContinuousQueryScanRequestBuilder msg;

    ContinuousQueryScanRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.continuousQueryScanRequest();
    }

    @Override
    public Class<ContinuousQueryScanRequest> klass() {
        return ContinuousQueryScanRequest.class;
    }

    @Override
    public ContinuousQueryScanRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.continuousQueryScanRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String[] tmp = reader.readObjectArray("columnNames", MessageCollectionItemType.STRING, String.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.columnNames(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String[] tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                byte tmp = reader.readByte("eventTypes");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.eventTypes(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("lowerBoundRowId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.lowerBoundRowId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                long tmp = reader.readLong("lowerBoundTimestampLong");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lowerBoundTimestampLong(tmp);
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("maxItems");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.maxItems(tmp);
                reader.incrementState();
            }
            case 7: {
                long tmp = reader.readLong("requestId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.requestId(tmp);
                reader.incrementState();
            }
            case 8: {
                int tmp = reader.readBoolean("skipOldEntries");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.skipOldEntries(tmp != 0);
                reader.incrementState();
            }
            case 9: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 10: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ContinuousQueryScanRequest.class);
    }
}

