/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryTupleMessageImpl;

class BinaryTupleMessageSerializer
implements MessageSerializer<BinaryTupleMessage> {
    public static final BinaryTupleMessageSerializer INSTANCE = new BinaryTupleMessageSerializer();

    private BinaryTupleMessageSerializer() {
    }

    @Override
    public boolean writeMessage(BinaryTupleMessage msg, MessageWriter writer) throws MessageMappingException {
        BinaryTupleMessageImpl message = (BinaryTupleMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryTupleMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("elementCount", message.elementCount());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteBuffer("tuple", message.tuple());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

