/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowVersionMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowVersionMessageImpl;

class BinaryRowVersionMessageSerializer
implements MessageSerializer<BinaryRowVersionMessage> {
    public static final BinaryRowVersionMessageSerializer INSTANCE = new BinaryRowVersionMessageSerializer();

    private BinaryRowVersionMessageSerializer() {
    }

    @Override
    public boolean writeMessage(BinaryRowVersionMessage msg, MessageWriter writer) throws MessageMappingException {
        BinaryRowVersionMessageImpl message = (BinaryRowVersionMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryRowVersionMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteBuffer("binaryTuple", message.binaryTuple());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBoolean("isArchived", message.isArchived());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoolean("tombstone", message.tombstone());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

