/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessageBuilder;

class BinaryRowMessageDeserializer
implements MessageDeserializer<BinaryRowMessage> {
    private final BinaryRowMessageBuilder msg;

    BinaryRowMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.binaryRowMessage();
    }

    @Override
    public Class<BinaryRowMessage> klass() {
        return BinaryRowMessage.class;
    }

    @Override
    public BinaryRowMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryRowMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("binaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.binaryTuple(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryRowMessage.class);
    }
}

