/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataRequestSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class SnapshotTxDataRequestImpl
implements SnapshotTxDataRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 15;
    @IgniteToStringInclude
    private final UUID id;
    @IgniteToStringInclude
    private final int maxTransactionsInBatch;

    private SnapshotTxDataRequestImpl(UUID id, int maxTransactionsInBatch) {
        this.id = id;
        this.maxTransactionsInBatch = maxTransactionsInBatch;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public int maxTransactionsInBatch() {
        return this.maxTransactionsInBatch;
    }

    public MessageSerializer serializer() {
        return SnapshotTxDataRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotTxDataRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 15;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotTxDataRequestImpl otherMessage = (SnapshotTxDataRequestImpl)other;
        return Objects.equals(this.id, otherMessage.id) && this.maxTransactionsInBatch == otherMessage.maxTransactionsInBatch;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.maxTransactionsInBatch, this.id);
        return result;
    }

    @Override
    public SnapshotTxDataRequestImpl clone() {
        try {
            return (SnapshotTxDataRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotTxDataRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SnapshotTxDataRequestBuilder {
        private UUID id;
        private int maxTransactionsInBatch;

        private Builder() {
        }

        @Override
        public SnapshotTxDataRequestBuilder id(UUID id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public SnapshotTxDataRequestBuilder maxTransactionsInBatch(int maxTransactionsInBatch) {
            this.maxTransactionsInBatch = maxTransactionsInBatch;
            return this;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public int maxTransactionsInBatch() {
            return this.maxTransactionsInBatch;
        }

        @Override
        public SnapshotTxDataRequest build() {
            return new SnapshotTxDataRequestImpl(Objects.requireNonNull(this.id, "id is not marked @Nullable"), this.maxTransactionsInBatch);
        }

        @Override
        public SnapshotTxDataRequest buildDeserialized() {
            return new SnapshotTxDataRequestImpl(this.id, this.maxTransactionsInBatch);
        }
    }
}

