/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataRequestBuilder;

class SnapshotTxDataRequestDeserializer
implements MessageDeserializer<SnapshotTxDataRequest> {
    private final SnapshotTxDataRequestBuilder msg;

    SnapshotTxDataRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotTxDataRequest();
    }

    @Override
    public Class<SnapshotTxDataRequest> klass() {
        return SnapshotTxDataRequest.class;
    }

    @Override
    public SnapshotTxDataRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.snapshotTxDataRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.id(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("maxTransactionsInBatch");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.maxTransactionsInBatch(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotTxDataRequest.class);
    }
}

