/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessage;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessageImpl;

class LocalTablePartitionStateMessageSerializer
implements MessageSerializer<LocalTablePartitionStateMessage> {
    public static final LocalTablePartitionStateMessageSerializer INSTANCE = new LocalTablePartitionStateMessageSerializer();

    private LocalTablePartitionStateMessageSerializer() {
    }

    @Override
    public boolean writeMessage(LocalTablePartitionStateMessage msg, MessageWriter writer) throws MessageMappingException {
        LocalTablePartitionStateMessageImpl message = (LocalTablePartitionStateMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.localTablePartitionStateMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMap("tablePartitionIdToEstimatedRowsMap", message.tablePartitionIdToEstimatedRowsMap(), MessageCollectionItemType.MSG, MessageCollectionItemType.LONG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

