/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequest;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequestSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class LocalPartitionStatesRequestImpl
implements LocalPartitionStatesRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 101;
    @IgniteToStringInclude
    private final int catalogVersion;
    @IgniteToStringInclude
    private final Set<Integer> partitionIds;
    @IgniteToStringInclude
    private final Set<Integer> zoneIds;

    private LocalPartitionStatesRequestImpl(int catalogVersion, Set<Integer> partitionIds, Set<Integer> zoneIds) {
        this.catalogVersion = catalogVersion;
        this.partitionIds = partitionIds;
        this.zoneIds = zoneIds;
    }

    @Override
    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public Set<Integer> partitionIds() {
        return this.partitionIds;
    }

    @Override
    public Set<Integer> zoneIds() {
        return this.zoneIds;
    }

    public MessageSerializer serializer() {
        return LocalPartitionStatesRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(LocalPartitionStatesRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 101;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalPartitionStatesRequestImpl otherMessage = (LocalPartitionStatesRequestImpl)other;
        return Objects.equals(this.partitionIds, otherMessage.partitionIds) && Objects.equals(this.zoneIds, otherMessage.zoneIds) && this.catalogVersion == otherMessage.catalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.catalogVersion, this.partitionIds, this.zoneIds);
        return result;
    }

    @Override
    public LocalPartitionStatesRequestImpl clone() {
        try {
            return (LocalPartitionStatesRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LocalPartitionStatesRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements LocalPartitionStatesRequestBuilder {
        private int catalogVersion;
        private Set<Integer> partitionIds;
        private Set<Integer> zoneIds;

        private Builder() {
        }

        @Override
        public LocalPartitionStatesRequestBuilder catalogVersion(int catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        @Override
        public LocalPartitionStatesRequestBuilder partitionIds(Set<Integer> partitionIds) {
            Objects.requireNonNull(partitionIds, "partitionIds is not marked @Nullable");
            this.partitionIds = partitionIds;
            return this;
        }

        @Override
        public LocalPartitionStatesRequestBuilder zoneIds(Set<Integer> zoneIds) {
            Objects.requireNonNull(zoneIds, "zoneIds is not marked @Nullable");
            this.zoneIds = zoneIds;
            return this;
        }

        @Override
        public int catalogVersion() {
            return this.catalogVersion;
        }

        @Override
        public Set<Integer> partitionIds() {
            return this.partitionIds;
        }

        @Override
        public Set<Integer> zoneIds() {
            return this.zoneIds;
        }

        @Override
        public LocalPartitionStatesRequest build() {
            return new LocalPartitionStatesRequestImpl(this.catalogVersion, Objects.requireNonNull(this.partitionIds, "partitionIds is not marked @Nullable"), Objects.requireNonNull(this.zoneIds, "zoneIds is not marked @Nullable"));
        }

        @Override
        public LocalPartitionStatesRequest buildDeserialized() {
            return new LocalPartitionStatesRequestImpl(this.catalogVersion, this.partitionIds, this.zoneIds);
        }
    }
}

