/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateAllCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateAllCommandV2Builder;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateAllCommandV2Serializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class UpdateAllCommandV2Impl
implements UpdateAllCommandV2,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 42;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage commitPartitionId;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final Long leaseStartTime;
    @IgniteToStringInclude
    private final Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final UUID txCoordinatorId;
    @IgniteToStringInclude
    private final UUID txId;

    private UpdateAllCommandV2Impl(ReplicationGroupIdMessage commitPartitionId, boolean full, HybridTimestamp initiatorTime, Long leaseStartTime, Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate, int requiredCatalogVersion, HybridTimestamp safeTime, int tableId, UUID txCoordinatorId, UUID txId) {
        this.commitPartitionId = commitPartitionId;
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.leaseStartTime = leaseStartTime;
        this.messageRowsToUpdate = messageRowsToUpdate;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.tableId = tableId;
        this.txCoordinatorId = txCoordinatorId;
        this.txId = txId;
    }

    @Override
    public ReplicationGroupIdMessage commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public Long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate() {
        return this.messageRowsToUpdate;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return UpdateAllCommandV2Serializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UpdateAllCommandV2Impl.class, this);
    }

    @Override
    public short messageType() {
        return 42;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateAllCommandV2Impl otherMessage = (UpdateAllCommandV2Impl)other;
        return Objects.equals(this.commitPartitionId, otherMessage.commitPartitionId) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && Objects.equals(this.messageRowsToUpdate, otherMessage.messageRowsToUpdate) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.txCoordinatorId, otherMessage.txCoordinatorId) && Objects.equals(this.txId, otherMessage.txId) && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.full, this.requiredCatalogVersion, this.tableId, this.commitPartitionId, this.initiatorTime, this.leaseStartTime, this.messageRowsToUpdate, this.safeTime, this.txCoordinatorId, this.txId);
        return result;
    }

    @Override
    public UpdateAllCommandV2Impl clone() {
        try {
            return (UpdateAllCommandV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateAllCommandV2Builder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.messageRowsToUpdate != null) {
            Set<Map.Entry<UUID, TimedBinaryRowMessage>> messageRowsToUpdateEntrySet = this.messageRowsToUpdate.entrySet();
            for (Map.Entry<UUID, TimedBinaryRowMessage> entry : messageRowsToUpdateEntrySet) {
                UUID key = entry.getKey();
                TimedBinaryRowMessage value = entry.getValue();
                if (value == null) continue;
                value.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.unmarshal(marshaller, descriptorsObj);
        }
        if (this.messageRowsToUpdate != null) {
            Set<Map.Entry<UUID, TimedBinaryRowMessage>> messageRowsToUpdateEntrySet = this.messageRowsToUpdate.entrySet();
            for (Map.Entry<UUID, TimedBinaryRowMessage> entry : messageRowsToUpdateEntrySet) {
                UUID key = entry.getKey();
                TimedBinaryRowMessage value = entry.getValue();
                if (value == null) continue;
                value.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements UpdateAllCommandV2Builder {
        private ReplicationGroupIdMessage commitPartitionId;
        private boolean full;
        private HybridTimestamp initiatorTime;
        private Long leaseStartTime;
        private Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private int tableId;
        private UUID txCoordinatorId;
        private UUID txId;

        private Builder() {
        }

        @Override
        public UpdateAllCommandV2Builder commitPartitionId(ReplicationGroupIdMessage commitPartitionId) {
            Objects.requireNonNull(commitPartitionId, "commitPartitionId is not marked @Nullable");
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder leaseStartTime(Long leaseStartTime) {
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder messageRowsToUpdate(Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate) {
            Objects.requireNonNull(messageRowsToUpdate, "messageRowsToUpdate is not marked @Nullable");
            this.messageRowsToUpdate = messageRowsToUpdate;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder txCoordinatorId(UUID txCoordinatorId) {
            Objects.requireNonNull(txCoordinatorId, "txCoordinatorId is not marked @Nullable");
            this.txCoordinatorId = txCoordinatorId;
            return this;
        }

        @Override
        public UpdateAllCommandV2Builder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public Long leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public Map<UUID, TimedBinaryRowMessage> messageRowsToUpdate() {
            return this.messageRowsToUpdate;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public UUID txCoordinatorId() {
            return this.txCoordinatorId;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public UpdateAllCommandV2 build() {
            return new UpdateAllCommandV2Impl(Objects.requireNonNull(this.commitPartitionId, "commitPartitionId is not marked @Nullable"), this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.leaseStartTime, Objects.requireNonNull(this.messageRowsToUpdate, "messageRowsToUpdate is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, this.tableId, Objects.requireNonNull(this.txCoordinatorId, "txCoordinatorId is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public UpdateAllCommandV2 buildDeserialized() {
            return new UpdateAllCommandV2Impl(this.commitPartitionId, this.full, this.initiatorTime, this.leaseStartTime, this.messageRowsToUpdate, this.requiredCatalogVersion, this.safeTime, this.tableId, this.txCoordinatorId, this.txId);
        }
    }
}

