/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.SecondarySafeTimeSyncCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.SecondarySafeTimeSyncCommandBuilder;

class SecondarySafeTimeSyncCommandDeserializer
implements MessageDeserializer<SecondarySafeTimeSyncCommand> {
    private final SecondarySafeTimeSyncCommandBuilder msg;

    SecondarySafeTimeSyncCommandDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.secondarySafeTimeSyncCommand();
    }

    @Override
    public Class<SecondarySafeTimeSyncCommand> klass() {
        return SecondarySafeTimeSyncCommand.class;
    }

    @Override
    public SecondarySafeTimeSyncCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.secondarySafeTimeSyncCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("proposedSafeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.proposedSafeTime(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SecondarySafeTimeSyncCommand.class);
    }
}

