/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2Builder;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2Serializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;

public class FinishTxCommandV2Impl
implements FinishTxCommandV2,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final List<EnlistedPartitionGroupMessage> partitions;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final UUID txId;

    private FinishTxCommandV2Impl(boolean commit, HybridTimestamp commitTimestamp, boolean full, HybridTimestamp initiatorTime, List<EnlistedPartitionGroupMessage> partitions, int requiredCatalogVersion, HybridTimestamp safeTime, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.partitions = partitions;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public List<EnlistedPartitionGroupMessage> partitions() {
        return this.partitions;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return FinishTxCommandV2Serializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(FinishTxCommandV2Impl.class, this);
    }

    @Override
    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FinishTxCommandV2Impl otherMessage = (FinishTxCommandV2Impl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.partitions, otherMessage.partitions) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.full, this.requiredCatalogVersion, this.commitTimestamp, this.initiatorTime, this.partitions, this.safeTime, this.txId);
        return result;
    }

    @Override
    public FinishTxCommandV2Impl clone() {
        try {
            return (FinishTxCommandV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FinishTxCommandV2Builder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (EnlistedPartitionGroupMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (EnlistedPartitionGroupMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements FinishTxCommandV2Builder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private boolean full;
        private HybridTimestamp initiatorTime;
        private List<EnlistedPartitionGroupMessage> partitions;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private UUID txId;

        private Builder() {
        }

        @Override
        public FinishTxCommandV2Builder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder partitions(List<EnlistedPartitionGroupMessage> partitions) {
            Objects.requireNonNull(partitions, "partitions is not marked @Nullable");
            this.partitions = partitions;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public FinishTxCommandV2Builder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public List<EnlistedPartitionGroupMessage> partitions() {
            return this.partitions;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public FinishTxCommandV2 build() {
            return new FinishTxCommandV2Impl(this.commit, this.commitTimestamp, this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.partitions, "partitions is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public FinishTxCommandV2 buildDeserialized() {
            return new FinishTxCommandV2Impl(this.commit, this.commitTimestamp, this.full, this.initiatorTime, this.partitions, this.requiredCatalogVersion, this.safeTime, this.txId);
        }
    }
}

