/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandV2Builder;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandV2Serializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class BuildIndexCommandV2Impl
implements BuildIndexCommandV2,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 44;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final int indexId;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private final List<UUID> rowIds;
    @IgniteToStringInclude
    private final int tableId;

    private BuildIndexCommandV2Impl(boolean finish, int indexId, int requiredCatalogVersion, List<UUID> rowIds, int tableId) {
        this.finish = finish;
        this.indexId = indexId;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.rowIds = rowIds;
        this.tableId = tableId;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public int indexId() {
        return this.indexId;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public List<UUID> rowIds() {
        return this.rowIds;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return BuildIndexCommandV2Serializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BuildIndexCommandV2Impl.class, this);
    }

    @Override
    public short messageType() {
        return 44;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildIndexCommandV2Impl otherMessage = (BuildIndexCommandV2Impl)other;
        return Objects.equals(this.rowIds, otherMessage.rowIds) && this.finish == otherMessage.finish && this.indexId == otherMessage.indexId && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.indexId, this.requiredCatalogVersion, this.tableId, this.rowIds);
        return result;
    }

    @Override
    public BuildIndexCommandV2Impl clone() {
        try {
            return (BuildIndexCommandV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BuildIndexCommandV2Builder builder() {
        return new Builder();
    }

    private static class Builder
    implements BuildIndexCommandV2Builder {
        private boolean finish;
        private int indexId;
        private int requiredCatalogVersion;
        private List<UUID> rowIds;
        private int tableId;

        private Builder() {
        }

        @Override
        public BuildIndexCommandV2Builder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public BuildIndexCommandV2Builder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public BuildIndexCommandV2Builder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public BuildIndexCommandV2Builder rowIds(List<UUID> rowIds) {
            Objects.requireNonNull(rowIds, "rowIds is not marked @Nullable");
            this.rowIds = rowIds;
            return this;
        }

        @Override
        public BuildIndexCommandV2Builder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public int indexId() {
            return this.indexId;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public List<UUID> rowIds() {
            return this.rowIds;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public BuildIndexCommandV2 build() {
            return new BuildIndexCommandV2Impl(this.finish, this.indexId, this.requiredCatalogVersion, Objects.requireNonNull(this.rowIds, "rowIds is not marked @Nullable"), this.tableId);
        }

        @Override
        public BuildIndexCommandV2 buildDeserialized() {
            return new BuildIndexCommandV2Impl(this.finish, this.indexId, this.requiredCatalogVersion, this.rowIds, this.tableId);
        }
    }
}

