/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.ArchiveAllCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.ArchiveAllCommandImpl;

class ArchiveAllCommandSerializer
implements MessageSerializer<ArchiveAllCommand> {
    public static final ArchiveAllCommandSerializer INSTANCE = new ArchiveAllCommandSerializer();

    private ArchiveAllCommandSerializer() {
    }

    @Override
    public boolean writeMessage(ArchiveAllCommand msg, MessageWriter writer) throws MessageMappingException {
        ArchiveAllCommandImpl message = (ArchiveAllCommandImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.archiveAllCommand());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)9)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("commitPartitionId", message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBoolean("full", message.full());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoxedLong("leaseStartTime", message.leaseStartTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeMap("messageRowsToUpdate", message.messageRowsToUpdate(), MessageCollectionItemType.UUID, MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeUuid("txCoordinatorId", message.txCoordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

