/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network;

import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite3.internal.partition.replicator.network.UserDetailsMessageBuilder;

class UserDetailsMessageDeserializer
implements MessageDeserializer<UserDetailsMessage> {
    private final UserDetailsMessageBuilder msg;

    UserDetailsMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.userDetailsMessage();
    }

    @Override
    public Class<UserDetailsMessage> klass() {
        return UserDetailsMessage.class;
    }

    @Override
    public UserDetailsMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.userDetailsMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("userName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userName(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readSet("userRoles", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userRoles((Set<String>)((Object)tmp));
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UserDetailsMessage.class);
    }
}

