/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.handlers;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.TxRecoveryEngine;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;

public class TxRecoveryMessageHandler {
    private static final IgniteLogger LOG = Loggers.forClass(TxRecoveryMessageHandler.class);
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final ZonePartitionId replicationGroupId;
    private final TxRecoveryEngine txRecoveryEngine;

    public TxRecoveryMessageHandler(TxStatePartitionStorage txStatePartitionStorage, ZonePartitionId replicationGroupId, TxRecoveryEngine txRecoveryEngine) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.replicationGroupId = replicationGroupId;
        this.txRecoveryEngine = txRecoveryEngine;
    }

    public CompletableFuture<Void> handle(TxRecoveryMessage request, UUID senderId) {
        UUID txId = request.txId();
        TxMeta txMeta = this.txStatePartitionStorage.get(txId);
        if (txMeta != null && TxState.isFinalState(txMeta.txState())) {
            return this.txRecoveryEngine.runCleanupOnNode(this.replicationGroupId, txId, senderId);
        }
        LOG.info("Orphan transaction has to be aborted [tx={}, meta={}].", txId, txMeta);
        return this.txRecoveryEngine.triggerTxRecovery(txId, senderId);
    }
}

