/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.util.CompletableFutures;

class StartedReplicationGroups {
    private static final IgniteLogger LOG = Loggers.forClass(StartedReplicationGroups.class);
    private final Map<ZonePartitionId, CompletableFuture<Void>> startingReplicationGroupIds = new ConcurrentHashMap<ZonePartitionId, CompletableFuture<Void>>();
    private final Set<ZonePartitionId> startedReplicationGroupIds = ConcurrentHashMap.newKeySet();

    StartedReplicationGroups() {
    }

    void beforeStartingGroup(ZonePartitionId zonePartitionId) {
        CompletableFuture startingFuture = new CompletableFuture();
        CompletableFuture prevFuture = this.startingReplicationGroupIds.put(zonePartitionId, startingFuture);
        assert (prevFuture == null) : "Replication group is starting second time. [zonePartitionId=" + zonePartitionId + "]";
        if (prevFuture != null) {
            LOG.info("Replication group is starting second time. [zonePartitionId=" + zonePartitionId + "]", new Object[0]);
            startingFuture.whenComplete(CompletableFutures.copyStateTo(prevFuture));
        }
    }

    void startingFailed(ZonePartitionId zonePartitionId) {
        this.completeStartingFuture(zonePartitionId);
    }

    void startingCompleted(ZonePartitionId zonePartitionId) {
        this.startedReplicationGroupIds.add(zonePartitionId);
        this.completeStartingFuture(zonePartitionId);
    }

    void afterStoppingGroup(ZonePartitionId zonePartitionId) {
        this.startedReplicationGroupIds.remove(zonePartitionId);
    }

    boolean hasReplicationGroupStarted(ZonePartitionId zonePartitionId) {
        return this.startedReplicationGroupIds.contains(zonePartitionId);
    }

    private void completeStartingFuture(ZonePartitionId zonePartitionId) {
        CompletableFuture<Void> startingFuture = this.startingReplicationGroupIds.remove(zonePartitionId);
        assert (startingFuture != null) : "Starting future is not found. [zonePartitionId=" + zonePartitionId + "]";
        if (startingFuture != null) {
            startingFuture.complete(null);
        } else {
            LOG.info("Starting future is not found. [zonePartitionId=" + zonePartitionId + "]", new Object[0]);
        }
    }

    void waitForStartingReplicas() {
        try {
            CompletableFutures.allOf(this.startingReplicationGroupIds.values()).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Failed to wait starting replicas before stop", (Throwable)e);
        }
    }

    Stream<ZonePartitionId> streamStartedReplicationGroups() {
        return this.startedReplicationGroupIds.stream();
    }
}

