/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.datapage;

import java.util.Objects;
import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ReadPageMemoryRowValue
implements PageMemoryTraversal<Void> {
    private boolean readingFirstSlot = true;
    private int valueSize;
    private byte @Nullable [] allValueBytes;
    private int transferredBytes = 0;

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, @Nullable Void ignoredArg) {
        if (this.readingFirstSlot) {
            this.readingFirstSlot = false;
            return this.readFullyOrStartReadingFragmented(pageAddr, payload);
        }
        return this.readNextFragment(pageAddr, payload);
    }

    private long readFullyOrStartReadingFragmented(long pageAddr, DataPagePayload payload) {
        byte dataType = PageUtils.getByte(pageAddr, payload.offset() + 0);
        this.valueSize = this.readValueSize(dataType, pageAddr, payload);
        if (!payload.hasMoreFragments()) {
            return this.readFully(dataType, pageAddr, payload);
        }
        this.allValueBytes = new byte[this.valueSize];
        this.transferredBytes = 0;
        this.readValueFragmentToArray(pageAddr, payload, this.valueOffsetInFirstSlot(dataType));
        return payload.nextLink();
    }

    private int readValueSize(byte dataType, long pageAddr, DataPagePayload payload) {
        return PageUtils.getInt(pageAddr, payload.offset() + this.valueSizeOffsetInFirstSlot(dataType));
    }

    private long readFully(byte dataType, long pageAddr, DataPagePayload payload) {
        this.allValueBytes = PageUtils.getBytes(pageAddr, payload.offset() + this.valueOffsetInFirstSlot(dataType), this.valueSize);
        return 0L;
    }

    private void readValueFragmentToArray(long pageAddr, DataPagePayload payload, int offsetToValue) {
        assert (this.allValueBytes != null);
        int valueBytesToRead = payload.payloadSize() - offsetToValue;
        PageUtils.getBytes(pageAddr, payload.offset() + offsetToValue, this.allValueBytes, this.transferredBytes, valueBytesToRead);
        this.transferredBytes += valueBytesToRead;
    }

    private long readNextFragment(long pageAddr, DataPagePayload payload) {
        assert (this.allValueBytes != null);
        this.readValueFragmentToArray(pageAddr, payload, 0);
        if (payload.hasMoreFragments()) {
            return payload.nextLink();
        }
        return 0L;
    }

    public byte[] result() {
        return Objects.requireNonNull(this.allValueBytes);
    }

    protected abstract int valueSizeOffsetInFirstSlot(byte var1);

    protected abstract int valueOffsetInFirstSlot(byte var1);

    public void reset() {
        this.readingFirstSlot = true;
        this.allValueBytes = null;
        this.transferredBytes = 0;
    }
}

