/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartResponseMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class HandshakeStartResponseMessageSerializer
implements MessageSerializer<HandshakeStartResponseMessage> {
    public static final HandshakeStartResponseMessageSerializer INSTANCE = new HandshakeStartResponseMessageSerializer();

    private HandshakeStartResponseMessageSerializer() {
    }

    @Override
    public boolean writeMessage(HandshakeStartResponseMessage msg, MessageWriter writer) throws MessageMappingException {
        HandshakeStartResponseMessageImpl message = (HandshakeStartResponseMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartResponseMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("clientNode", message.clientNode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeShort("connectionId", message.connectionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("receivedCount", message.receivedCount());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

