/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.OutNetworkObject;
import org.apache.ignite3.internal.network.RecipientLeftException;
import org.apache.ignite3.internal.network.handshake.HandshakeException;
import org.apache.ignite3.internal.network.handshake.HelloMessage;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.netty.InboundDecoder;
import org.apache.ignite3.internal.network.netty.NettySender;
import org.apache.ignite3.internal.network.netty.NettyUtils;
import org.apache.ignite3.internal.network.netty.OutboundEncoder;
import org.apache.ignite3.internal.network.recovery.ChannelNegotiation;
import org.apache.ignite3.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeRejectionReason;
import org.apache.ignite3.internal.network.ru.CompatibilityRollingUpgradeMessageFormat;
import org.apache.ignite3.internal.network.ru.RollingUpgradeMessageFormat;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.version.IgniteProductVersionSource;

class HandshakeManagerUtils {
    private static final IgniteLogger LOG = Loggers.forClass(HandshakeManagerUtils.class);
    private static final NetworkMessagesFactory MESSAGE_FACTORY = new NetworkMessagesFactory();
    private static final IgniteProductVersion TRANSIENT_FIELDS_ISSUE_FIXED_VERSION = IgniteProductVersion.fromString("9.1.16");

    HandshakeManagerUtils() {
    }

    static void sendRejectionMessageAndFailHandshake(String message, HandshakeRejectionReason rejectionReason, Channel channel, CompletableFuture<NettySender> handshakeFuture, Function<String, Exception> exceptionFactory) {
        HandshakeManagerUtils.sendRejectionMessageAndFailHandshake(message, message, rejectionReason, channel, handshakeFuture, exceptionFactory);
    }

    static void sendRejectionMessageAndFailHandshake(String exceptionText, String messageText, HandshakeRejectionReason rejectionReason, Channel channel, CompletableFuture<NettySender> handshakeFuture, Function<String, Exception> exceptionFactory) {
        rejectionReason.print(false, LOG, "Rejecting handshake: {}", messageText);
        HandshakeRejectedMessage rejectionMessage = MESSAGE_FACTORY.handshakeRejectedMessage().reasonString(rejectionReason.name()).message(messageText).build();
        ChannelFuture sendFuture = channel.writeAndFlush((Object)new OutNetworkObject(rejectionMessage, Collections.emptyList()));
        NettyUtils.toCompletableFuture(sendFuture).whenComplete((unused, ex) -> handshakeFuture.completeExceptionally((Throwable)exceptionFactory.apply(exceptionText)));
    }

    static ClusterNodeMessage clusterNodeToMessage(InternalClusterNode node) {
        return MESSAGE_FACTORY.clusterNodeMessage().id(node.id()).name(node.name()).host(node.address().host()).port(node.address().port()).build();
    }

    static void switchToNegotiatedBinaryFormat(HelloMessage helloFromOtherSide, ChannelHandlerContext ctx, IgniteProductVersionSource productVersionSource) {
        InboundDecoder inboundDecoder = (InboundDecoder)ctx.pipeline().get(InboundDecoder.class);
        OutboundEncoder outboundEncoder = (OutboundEncoder)ctx.pipeline().get(OutboundEncoder.class);
        byte commonBinaryStreamVersion = ChannelNegotiation.commonBinaryStreamVersion((byte)1, helloFromOtherSide.binaryStreamVersion());
        if (ChannelNegotiation.productVersionDiffers(productVersionSource.productVersion().toString(), helloFromOtherSide.productVersion())) {
            RollingUpgradeMessageFormat rollingUpgradeMessageFormat = HandshakeManagerUtils.otherSideNeedsCompatibilityMessageFormat(helloFromOtherSide.productVersion()) ? new CompatibilityRollingUpgradeMessageFormat() : new RollingUpgradeMessageFormat();
            inboundDecoder.changeBinaryFormat(commonBinaryStreamVersion, rollingUpgradeMessageFormat, ctx.channel());
            outboundEncoder.changeBinaryFormat(commonBinaryStreamVersion, rollingUpgradeMessageFormat, ctx.channel());
        } else {
            inboundDecoder.changeBinaryFormat(commonBinaryStreamVersion, ctx.channel());
            outboundEncoder.changeBinaryFormat(commonBinaryStreamVersion, ctx.channel());
        }
    }

    private static boolean otherSideNeedsCompatibilityMessageFormat(String otherSideVersion) {
        return IgniteProductVersion.fromString(otherSideVersion).compareTo(TRANSIENT_FIELDS_ISSUE_FIXED_VERSION) < 0;
    }

    static Exception createExceptionFromRejectionMessage(HandshakeRejectedMessage msg) {
        return msg.reason() == HandshakeRejectionReason.STOPPING ? new RecipientLeftException(msg.message()) : new HandshakeException(msg.message());
    }
}

