/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.ignite3.internal.network.handshake.HelloMessageSender;
import org.apache.ignite3.internal.network.handshake.UnsupportedProtocolException;
import org.apache.ignite3.internal.network.netty.PipelineUtils;
import org.apache.ignite3.internal.network.netty.ProtocolSniffer;
import org.apache.ignite3.internal.version.IgniteProductVersionSource;

public class InitiatorProtocolSniffer
extends ChannelInboundHandlerAdapter {
    static final String NAME = "initiator-protocol-sniffer";
    private static final int NETWORK_GROUP_ID_BYTE = 2;
    private static final int HANDSHAKE_START_MESSAGE_ID_BYTE = 4;
    private static final int PROBE_MESSAGE_ID_BYTE = 13;
    private final IgniteProductVersionSource productVersionSource;
    private static final int STAGE_READING_FIRST_BYTE = 0;
    private static final int STAGE_READING_SECOND_BYTE = 1;
    private static final int STAGE_PROCESSING_PAYLOAD = 2;
    private int stage = 0;
    private int byte1;
    private int byte2;

    public InitiatorProtocolSniffer(IgniteProductVersionSource productVersionSource) {
        this.productVersionSource = productVersionSource;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            super.channelRead(ctx, msg);
            return;
        }
        ByteBuf in = (ByteBuf)msg;
        if (!in.isReadable()) {
            super.channelRead(ctx, msg);
            return;
        }
        switch (this.stage) {
            case 0: {
                this.byte1 = in.readByte();
                if (this.byte1 != 2) {
                    throw new UnsupportedProtocolException("Unexpected byte 1: " + this.byte1 + "; the acceptor uses some unsupported protocol");
                }
                this.stage = 1;
                if (!in.isReadable()) {
                    return;
                }
            }
            case 1: {
                this.byte2 = in.readByte();
                if (this.byte2 != 13 && this.byte2 != 4) {
                    throw new UnsupportedProtocolException("Unexpected byte 2: " + this.byte2 + "; the acceptor uses some unsupported protocol");
                }
                this.stage = 2;
                if (this.byte2 == 4) {
                    ProtocolSniffer.setDetectedNewProtocol(ctx, false);
                    ctx.pipeline().remove((ChannelHandler)this);
                    ByteBuf compositeBuf = this.prependWithConsumedPart(ctx, in);
                    super.channelRead(ctx, (Object)compositeBuf);
                    return;
                }
                if (!in.isReadable()) {
                    return;
                }
            }
            case 2: {
                in.readByte();
                ProtocolSniffer.setDetectedNewProtocol(ctx, true);
                ctx.pipeline().remove((ChannelHandler)this);
                PipelineUtils.addHelloMessageDecoder(ctx.pipeline());
                new HelloMessageSender(this.productVersionSource).sendHelloMessage(ctx);
                super.channelRead(ctx, msg);
                return;
            }
        }
        throw new IllegalStateException("Should never be here, stage is " + this.stage);
    }

    private ByteBuf prependWithConsumedPart(ChannelHandlerContext ctx, ByteBuf in) {
        ByteBuf prefixBuf = ctx.alloc().buffer(2);
        prefixBuf.writeByte(this.byte1);
        prefixBuf.writeByte(this.byte2);
        CompositeByteBuf compositeBuf = ctx.alloc().compositeBuffer(2);
        compositeBuf.addComponent(true, prefixBuf);
        compositeBuf.addComponent(true, in);
        return compositeBuf;
    }
}

