/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.message.ScaleCubeMessage;
import org.apache.ignite3.internal.network.message.ScaleCubeMessageBuilder;
import org.apache.ignite3.internal.network.message.ScaleCubeMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ScaleCubeMessageImpl
implements ScaleCubeMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private Object data;
    private byte[] dataByteArray;
    @IgniteToStringInclude
    private final Map<String, String> headers;
    @IgniteToStringInclude
    private final NetworkMessage message;

    private ScaleCubeMessageImpl(Object data, byte[] dataByteArray, Map<String, String> headers, NetworkMessage message) {
        this.data = data;
        this.dataByteArray = dataByteArray;
        this.headers = headers;
        this.message = message;
    }

    byte[] dataByteArray() {
        return this.dataByteArray;
    }

    @Override
    public Object data() {
        return this.data;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public NetworkMessage message() {
        return this.message;
    }

    public MessageSerializer serializer() {
        return ScaleCubeMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ScaleCubeMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ScaleCubeMessageImpl otherMessage = (ScaleCubeMessageImpl)other;
        return Objects.equals(this.data, otherMessage.data) && Objects.equals(this.headers, otherMessage.headers) && Objects.equals(this.message, otherMessage.message);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.data, this.headers, this.message);
        return result;
    }

    @Override
    public ScaleCubeMessageImpl clone() {
        try {
            return (ScaleCubeMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ScaleCubeMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject dataByteArraymo = marshaller.marshal(this.data);
        usedDescriptors.addAll((IntCollection)dataByteArraymo.usedDescriptorIds());
        this.dataByteArray = dataByteArraymo.bytes();
        if (this.message != null) {
            this.message.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.data = marshaller.unmarshal(this.dataByteArray, descriptorsObj);
        this.dataByteArray = null;
        if (this.message != null) {
            this.message.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ScaleCubeMessageBuilder {
        private Object data;
        private byte[] dataByteArray;
        private Map<String, String> headers;
        private NetworkMessage message;

        private Builder() {
        }

        @Override
        public ScaleCubeMessageBuilder data(Object data) {
            this.data = data;
            return this;
        }

        @Override
        public ScaleCubeMessageBuilder dataByteArray(byte[] dataByteArray) {
            this.dataByteArray = dataByteArray;
            return this;
        }

        @Override
        public ScaleCubeMessageBuilder headers(Map<String, String> headers) {
            Objects.requireNonNull(headers, "headers is not marked @Nullable");
            this.headers = headers;
            return this;
        }

        @Override
        public ScaleCubeMessageBuilder message(NetworkMessage message) {
            this.message = message;
            return this;
        }

        @Override
        public Object data() {
            return this.data;
        }

        @Override
        public byte[] dataByteArray() {
            return this.dataByteArray;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        @Override
        public NetworkMessage message() {
            return this.message;
        }

        @Override
        public ScaleCubeMessage build() {
            return new ScaleCubeMessageImpl(this.data, this.dataByteArray, Objects.requireNonNull(this.headers, "headers is not marked @Nullable"), this.message);
        }

        @Override
        public ScaleCubeMessage buildDeserialized() {
            return new ScaleCubeMessageImpl(this.data, this.dataByteArray, this.headers, this.message);
        }
    }
}

