/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl.raft;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.metastorage.impl.raft.StartupMetaStorageSnapshotReader;
import org.apache.ignite3.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite3.internal.raft.IndexWithTerm;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite3.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite3.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.jetbrains.annotations.Nullable;

public class MetaStorageSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final KeyValueStorage storage;
    @Nullable
    private final RaftOutter.SnapshotMeta startupSnapshotMeta;
    private final RaftGroupConfigurationConverter configurationConverter = new RaftGroupConfigurationConverter();

    public MetaStorageSnapshotStorageFactory(KeyValueStorage storage) {
        this.storage = storage;
        this.startupSnapshotMeta = this.readStartupSnapshotMeta();
    }

    @Nullable
    private RaftOutter.SnapshotMeta readStartupSnapshotMeta() {
        IndexWithTerm indexWithTerm = this.storage.getIndexWithTerm();
        if (indexWithTerm == null) {
            return null;
        }
        byte[] configBytes = this.storage.getConfiguration();
        assert (configBytes != null);
        RaftGroupConfiguration configuration = this.configurationConverter.fromBytes(configBytes);
        assert (configuration != null);
        return new RaftMessagesFactory().snapshotMeta().cfgIndex(configuration.index()).cfgTerm(configuration.term()).lastIncludedIndex(indexWithTerm.index()).lastIncludedTerm(indexWithTerm.term()).peersList(configuration.peers()).oldPeersList(configuration.oldPeers()).learnersList(configuration.learners()).sequenceToken(configuration.sequenceToken()).oldSequenceToken(configuration.oldSequenceToken()).oldLearnersList(configuration.oldLearners()).build();
    }

    @Override
    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        return new LocalSnapshotStorage(uri, raftOptions){
            private final AtomicBoolean startupSnapshotOpened;
            {
                this.startupSnapshotOpened = new AtomicBoolean(false);
            }

            @Override
            public SnapshotReader open() {
                if (this.startupSnapshotOpened.compareAndSet(false, true)) {
                    if (MetaStorageSnapshotStorageFactory.this.startupSnapshotMeta == null) {
                        return null;
                    }
                    return new StartupMetaStorageSnapshotReader(MetaStorageSnapshotStorageFactory.this.startupSnapshotMeta);
                }
                return super.open();
            }
        };
    }
}

