/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metastorage.server.RecoveryRevisionsListener;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;

class RecoveryRevisionsListenerImpl
implements RecoveryRevisionsListener {
    private final IgniteSpinBusyLock busyLock;
    private final CompletableFuture<Revisions> recoveryFinishFuture;
    private final Lock lock = new ReentrantLock();
    private Revisions targetRevisions;
    private Revisions currentRevisions;

    RecoveryRevisionsListenerImpl(IgniteSpinBusyLock busyLock, CompletableFuture<Revisions> recoveryFinishFuture) {
        this.busyLock = busyLock;
        this.recoveryFinishFuture = recoveryFinishFuture;
    }

    @Override
    public void onUpdate(Revisions currentRevisions) {
        this.completeRecoveryFinishFutureIfPossible(() -> {
            this.currentRevisions = currentRevisions;
        });
    }

    void setTargetRevisions(Revisions targetRevisions) {
        this.completeRecoveryFinishFutureIfPossible(() -> {
            this.targetRevisions = targetRevisions;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRecoveryFinishFutureIfPossible(Runnable updateFieldFunction) {
        if (!this.busyLock.enterBusy()) {
            this.recoveryFinishFuture.completeExceptionally(new NodeStoppingException());
            return;
        }
        boolean recoveryAchieved = false;
        Throwable throwable = null;
        try {
            this.lock.lock();
            try {
                updateFieldFunction.run();
                recoveryAchieved = this.isRecoveryAchieved();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
        if (throwable != null) {
            this.recoveryFinishFuture.completeExceptionally(throwable);
            throw (RuntimeException)ExceptionUtils.sneakyThrow(throwable);
        }
        if (recoveryAchieved) {
            this.recoveryFinishFuture.complete(this.currentRevisions);
        }
    }

    private boolean isRecoveryAchieved() {
        return this.targetRevisions != null && this.currentRevisions != null && this.currentRevisions.revision() >= this.targetRevisions.revision() && this.currentRevisions.compactionRevision() >= this.targetRevisions.compactionRevision();
    }
}

