/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.PutCommand;
import org.apache.ignite3.internal.metastorage.command.PutCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.PutCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class PutCommandImpl
implements PutCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final ByteBuffer value;

    private PutCommandImpl(HybridTimestamp initiatorTime, ByteBuffer key, HybridTimestamp safeTime, ByteBuffer value) {
        this.initiatorTime = initiatorTime;
        this.key = key;
        this.safeTime = safeTime;
        this.value = value;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    public MessageSerializer serializer() {
        return PutCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(PutCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PutCommandImpl otherMessage = (PutCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.key, otherMessage.key) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.value, otherMessage.value);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.key, this.safeTime, this.value);
        return result;
    }

    @Override
    public PutCommandImpl clone() {
        try {
            return (PutCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PutCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PutCommandBuilder {
        private HybridTimestamp initiatorTime;
        private ByteBuffer key;
        private HybridTimestamp safeTime;
        private ByteBuffer value;

        private Builder() {
        }

        @Override
        public PutCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public PutCommandBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public PutCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public PutCommandBuilder value(ByteBuffer value) {
            Objects.requireNonNull(value, "value is not marked @Nullable");
            this.value = value;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public ByteBuffer value() {
            return this.value;
        }

        @Override
        public PutCommand build() {
            return new PutCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.key, "key is not marked @Nullable"), this.safeTime, Objects.requireNonNull(this.value, "value is not marked @Nullable"));
        }

        @Override
        public PutCommand buildDeserialized() {
            return new PutCommandImpl(this.initiatorTime, this.key, this.safeTime, this.value);
        }
    }
}

