/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.metastorage.command.GetCommand;
import org.apache.ignite3.internal.metastorage.command.GetCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class GetCommandDeserializer
implements MessageDeserializer<GetCommand> {
    private final GetCommandBuilder msg;

    GetCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.getCommand();
    }

    @Override
    public Class<GetCommand> klass() {
        return GetCommand.class;
    }

    @Override
    public GetCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.getCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.key(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("revision");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.revision(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GetCommand.class);
    }
}

