/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.EvictIdempotentCommandsCacheCommand;
import org.apache.ignite3.internal.metastorage.command.EvictIdempotentCommandsCacheCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class EvictIdempotentCommandsCacheCommandDeserializer
implements MessageDeserializer<EvictIdempotentCommandsCacheCommand> {
    private final EvictIdempotentCommandsCacheCommandBuilder msg;

    EvictIdempotentCommandsCacheCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.evictIdempotentCommandsCacheCommand();
    }

    @Override
    public Class<EvictIdempotentCommandsCacheCommand> klass() {
        return EvictIdempotentCommandsCacheCommand.class;
    }

    @Override
    public EvictIdempotentCommandsCacheCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.evictIdempotentCommandsCacheCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("evictionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.evictionTimestamp(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(EvictIdempotentCommandsCacheCommand.class);
    }
}

