/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite3.internal.marshaller.CreatorFromAnnotatedConstructorParameters;
import org.apache.ignite3.internal.marshaller.CreatorFromAnnotatedFieldsWithDefaultConstructor;
import org.apache.ignite3.internal.marshaller.FieldAccessor;
import org.apache.ignite3.internal.marshaller.MarshallerReader;

@FunctionalInterface
interface Creator {
    public Object createInstance(FieldAccessor[] var1, MarshallerReader var2);

    public static Creator of(Class<?> clazz) {
        try {
            if (Creator.isRecord(clazz)) {
                Constructor<?> canonicalCtor = Creator.getCanonicalConstructor(clazz);
                return new CreatorFromAnnotatedConstructorParameters(canonicalCtor);
            }
            Constructor<?> defaultCtor = clazz.getDeclaredConstructor(new Class[0]);
            return new CreatorFromAnnotatedFieldsWithDefaultConstructor(defaultCtor);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Could not find default (no-args) or canonical (record) constructor for " + clazz, ex);
        }
    }

    private static boolean isRecord(Class<?> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (Runtime.version().version().get(0) < 14) {
            return false;
        }
        Method isRecordMtd = Class.class.getDeclaredMethod("isRecord", new Class[0]);
        return (Boolean)isRecordMtd.invoke(clazz, new Object[0]);
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method getRecordComponentsMtd = Class.class.getDeclaredMethod("getRecordComponents", new Class[0]);
        Object[] recordComponents = (Object[])getRecordComponentsMtd.invoke(clazz, new Object[0]);
        Method getTypeMtd = Class.forName("java.lang.reflect.RecordComponent").getDeclaredMethod("getType", new Class[0]);
        Class[] types = new Class[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            types[i] = (Class)getTypeMtd.invoke(recordComponents[i], new Object[0]);
        }
        return clazz.getDeclaredConstructor(types);
    }
}

