/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc;

import java.sql.SQLException;
import org.apache.ignite3.internal.jdbc.ClientSyncResultSet;
import org.apache.ignite3.internal.jdbc.JdbcResultSet;

final class ResultSetWrapper {
    private JdbcResultSet resultSet;

    ResultSetWrapper(JdbcResultSet first) {
        this.resultSet = first;
    }

    void setCloseStatement(boolean b) {
        this.resultSet.setCloseStatement(b);
    }

    JdbcResultSet current() {
        return this.resultSet;
    }

    boolean isQuery() {
        ClientSyncResultSet rs = this.resultSet.resultSet();
        return rs.hasRowSet();
    }

    int updateCount() {
        JdbcResultSet rs = this.resultSet;
        ClientSyncResultSet clientResultSet = rs.resultSet();
        if (clientResultSet.hasRowSet()) {
            return -1;
        }
        if (clientResultSet.affectedRows() == -1L) {
            return 0;
        }
        return (int)clientResultSet.affectedRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean nextResultSet() throws SQLException {
        JdbcResultSet current = this.resultSet;
        if (current == null) {
            return false;
        }
        try {
            JdbcResultSet nextRs = current.tryNextResultSet();
            boolean hasNext = nextRs != null;
            this.resultSet = nextRs;
            boolean bl = hasNext;
            return bl;
        }
        finally {
            current.close();
        }
    }

    void close() throws SQLException {
        JdbcResultSet rs = this.resultSet;
        if (rs == null || rs.closed) {
            return;
        }
        this.resultSet = null;
        do {
            try {
                rs.close();
                rs = rs.tryNextResultSet();
            }
            catch (SQLException ignore) {
                break;
            }
        } while (rs != null);
    }
}

