/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.ignite3.internal.jdbc.JdbcConverterUtils;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.ResultSetMetadata;

public class JdbcResultSetMetadata
implements ResultSetMetaData {
    private static final int COLUMN_DISPLAY_SIZE = 30;
    private final List<ColumnMetadata> cols;

    public JdbcResultSetMetadata(ResultSetMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata");
        }
        this.cols = metadata.columns();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.cols.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).nullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.getColumn(column);
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.getColumn(column);
        return 30;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        ColumnMetadata metadata = this.getColumn(column);
        return metadata.name();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        ColumnMetadata metadata = this.getColumn(column);
        ColumnMetadata.ColumnOrigin origin = metadata.origin();
        if (origin != null && origin.columnName() != null) {
            return origin.columnName();
        }
        return metadata.name();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        ColumnMetadata.ColumnOrigin origin = this.getColumn(column).origin();
        return origin != null ? origin.schemaName() : null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).precision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).scale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        ColumnMetadata.ColumnOrigin origin = this.getColumn(column).origin();
        return origin != null ? origin.tableName() : null;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.getColumn(column);
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnType columnType = this.getColumn(column).type();
        return JdbcColumnMeta.typeId(columnType);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnType columnType = this.getColumn(column).type();
        return JdbcColumnMeta.typeName(columnType);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.getColumn(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnType columnType = this.getColumn(column).type();
        return JdbcConverterUtils.columnTypeToJdbcClass(columnType).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Result set meta data is not a wrapper for " + iface.getName());
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcResultSetMetadata.class);
    }

    private ColumnMetadata getColumn(int idx) throws SQLException {
        if (idx < 1 || idx > this.cols.size()) {
            throw new SQLException("Invalid column index: " + idx);
        }
        return this.cols.get(idx - 1);
    }
}

