/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.client.TcpIgniteClient;
import org.apache.ignite3.internal.jdbc.proto.JdbcDatabaseMetadataHandler;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaTablesResult;

public class JdbcClientDatabaseMetadataHandler
implements JdbcDatabaseMetadataHandler {
    private final TcpIgniteClient client;

    public JdbcClientDatabaseMetadataHandler(TcpIgniteClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<JdbcMetaTablesResult> tablesMetaAsync(JdbcMetaTablesRequest req) {
        return this.client.sendRequestAsync(38, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaTablesResult res = new JdbcMetaTablesResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaColumnsResult> columnsMetaAsync(JdbcMetaColumnsRequest req) {
        return this.client.sendRequestAsync(39, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaColumnsResult res = new JdbcMetaColumnsResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaSchemasResult> schemasMetaAsync(JdbcMetaSchemasRequest req) {
        return this.client.sendRequestAsync(40, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaSchemasResult res = new JdbcMetaSchemasResult();
            res.readBinary(r.in());
            return res;
        });
    }

    @Override
    public CompletableFuture<JdbcMetaPrimaryKeysResult> primaryKeysMetaAsync(JdbcMetaPrimaryKeysRequest req) {
        return this.client.sendRequestAsync(41, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaPrimaryKeysResult res = new JdbcMetaPrimaryKeysResult();
            res.readBinary(r.in());
            return res;
        });
    }
}

