/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntPredicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite3.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite3.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite3.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite3.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.index.ChangeIndexStatusTaskScheduler;
import org.apache.ignite3.internal.index.IndexManagementUtils;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite3.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.table.LongPriorityQueue;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

class ChangeIndexStatusTaskController
implements ManuallyCloseable {
    private final CatalogService catalogService;
    private final PlacementDriver placementDriver;
    private final ClusterService clusterService;
    private final LowWatermark lowWatermark;
    private final ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler;
    private final Set<Integer> localNodeIsPrimaryReplicaForTableIds = ConcurrentHashMap.newKeySet();
    private final Set<Integer> localNodeIsPrimaryReplicaForZoneIds = ConcurrentHashMap.newKeySet();
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue<DestroyTableEvent>(DestroyTableEvent::catalogVersion);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    ChangeIndexStatusTaskController(CatalogManager catalogManager, PlacementDriver placementDriver, ClusterService clusterService, LowWatermark lowWatermark, ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler) {
        this.catalogService = catalogManager;
        this.placementDriver = placementDriver;
        this.clusterService = clusterService;
        this.lowWatermark = lowWatermark;
        this.changeIndexStatusTaskScheduler = changeIndexStatusTaskScheduler;
    }

    public void start() {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, this::addListeners);
    }

    @Override
    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.changeIndexStatusTaskScheduler.close();
    }

    private void addListeners() {
        this.catalogService.listen(CatalogEvent.INDEX_CREATE, EventListener.fromConsumer(this::onIndexCreated));
        this.catalogService.listen(CatalogEvent.INDEX_STOPPING, EventListener.fromConsumer(this::onIndexDropped));
        this.catalogService.listen(CatalogEvent.INDEX_REMOVED, EventListener.fromConsumer(this::onIndexRemoved));
        this.catalogService.listen(CatalogEvent.TABLE_CREATE, EventListener.fromConsumer(this::onTableCreated));
        this.catalogService.listen(CatalogEvent.TABLE_DROP, EventListener.fromConsumer(this::onTableDropped));
        this.lowWatermark.listen(LowWatermarkEvent.LOW_WATERMARK_CHANGED, EventListener.fromConsumer(this::onLwmChanged));
        this.placementDriver.listen(PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, EventListener.fromConsumer(this::onPrimaryReplicaElected));
    }

    private void onIndexCreated(CreateIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            CatalogIndexDescriptor indexDescriptor = parameters.indexDescriptor();
            if (indexDescriptor.isCreatedWithTable()) {
                return;
            }
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(parameters.indexDescriptor());
            }
        });
    }

    private void onIndexDropped(StoppingIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            Catalog catalog = this.catalogService.catalog(parameters.catalogVersion());
            CatalogIndexDescriptor indexDescriptor = catalog.index(parameters.indexId());
            assert (indexDescriptor != null) : parameters.indexId();
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
            }
        });
    }

    private void onIndexRemoved(RemoveIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.changeIndexStatusTaskScheduler.stopStartBuildingTask(parameters.indexId()));
    }

    private void onTableCreated(CreateTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            CatalogTableDescriptor tableDescriptor = parameters.tableDescriptor();
            if (this.localNodeIsPrimaryReplicaForZoneIds.contains(tableDescriptor.zoneId())) {
                this.localNodeIsPrimaryReplicaForTableIds.add(tableDescriptor.id());
            }
        });
    }

    private void onTableDropped(DropTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.destructionEventsQueue.enqueue(new DestroyTableEvent(parameters.catalogVersion(), parameters.tableId())));
    }

    private void onPrimaryReplicaElected(PrimaryReplicaEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            ZonePartitionId primaryReplicaId = (ZonePartitionId)parameters.groupId();
            if (primaryReplicaId.partitionId() != 0) {
                return;
            }
            if (IndexManagementUtils.isLocalNode(this.clusterService, parameters.leaseholderId())) {
                this.scheduleTasksOnPrimaryReplicaElectedBusy(primaryReplicaId);
            } else {
                this.handlePrimacyLoss(primaryReplicaId);
            }
        });
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        int earliestVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
        List<DestroyTableEvent> tablesToDestroy = this.destructionEventsQueue.drainUpTo(earliestVersion);
        tablesToDestroy.forEach(event -> {
            this.localNodeIsPrimaryReplicaForTableIds.remove(event.tableId());
            this.changeIndexStatusTaskScheduler.stopTasksForTable(event.tableId());
        });
    }

    private void scheduleTasksOnPrimaryReplicaElectedBusy(ZonePartitionId zonePartitionId) {
        Catalog catalog = this.catalogService.catalog(this.catalogService.latestCatalogVersion());
        IntArrayList tableIds = ChangeIndexStatusTaskController.getTableIdsForPrimaryReplicaElected(catalog, zonePartitionId, id -> !this.localNodeIsPrimaryReplicaForTableIds.contains(id));
        this.localNodeIsPrimaryReplicaForTableIds.addAll((Collection<Integer>)tableIds);
        List<Integer> zoneIds = this.getZoneIdsForPrimaryReplicaElected(zonePartitionId);
        this.localNodeIsPrimaryReplicaForZoneIds.addAll(zoneIds);
        tableIds.forEach(tableId -> {
            for (CatalogIndexDescriptor indexDescriptor : catalog.indexes(tableId)) {
                switch (indexDescriptor.status()) {
                    case REGISTERED: {
                        this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(indexDescriptor);
                        break;
                    }
                    case STOPPING: {
                        this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
                        break;
                    }
                }
            }
        });
    }

    private void handlePrimacyLoss(ZonePartitionId zonePartitionId) {
        Catalog catalog = this.catalogService.catalog(this.catalogService.latestCatalogVersion());
        IntArrayList tableIds = ChangeIndexStatusTaskController.getTableIdsForPrimaryReplicaElected(catalog, zonePartitionId, this.localNodeIsPrimaryReplicaForTableIds::contains);
        this.localNodeIsPrimaryReplicaForTableIds.removeAll((Collection<?>)tableIds);
        this.localNodeIsPrimaryReplicaForZoneIds.remove(zonePartitionId.zoneId());
        tableIds.forEach(this.changeIndexStatusTaskScheduler::stopTasksForTable);
    }

    private static IntArrayList getTableIdsForPrimaryReplicaElected(Catalog catalog, ZonePartitionId zonePartitionId, IntPredicate predicate) {
        IntArrayList tableIds = new IntArrayList();
        for (CatalogTableDescriptor table : catalog.tables(zonePartitionId.zoneId())) {
            if (!predicate.test(table.id())) continue;
            tableIds.add(table.id());
        }
        return tableIds;
    }

    private List<Integer> getZoneIdsForPrimaryReplicaElected(ZonePartitionId zonePartitionId) {
        if (!this.localNodeIsPrimaryReplicaForZoneIds.contains(zonePartitionId.zoneId())) {
            return List.of(Integer.valueOf(zonePartitionId.zoneId()));
        }
        return List.of();
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        private DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        int catalogVersion() {
            return this.catalogVersion;
        }

        int tableId() {
            return this.tableId;
        }
    }
}

