/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import org.apache.ignite3.configuration.validation.MultipleOf;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;

public class MultipleOfValidator
implements Validator<MultipleOf, Number> {
    @Override
    public void validate(MultipleOf annotation, ValidationContext<Number> ctx) {
        long annotationValue = annotation.value();
        if (annotationValue <= 0L) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Value must be positive."));
            return;
        }
        long value = ctx.getNewValue().longValue();
        if (value % annotationValue != 0L) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Configuration value '" + value + "' must be a multiple of " + annotationValue));
        }
    }
}

